// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for testing a packed file.
//......................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	LPCTSTR				lpszStopSign;
extern	HWND				hDialogModeLess;
extern	HWND				hDlgCurrent;
extern	BOOL				bProcessInProgress;
extern	BOOL				bCancelOperation;
extern	LPBYTE				lpFileName;
extern	LPBYTE				lpFileExtension;
extern	HICON				hIcon;
extern	int					iStepIncrement;
extern	TCHAR				szFileName[MAX_PATH];
extern	HANDLE				hInputFile;
extern	int					iNumberOfFiles;
extern	LPBYTE				lpCrc32Table;
extern	PACKED_FILE_HEADER	pfhdr;
extern	PACKED_FILE_ID_HDR	pfidhdr;
extern	BYTE				PackedFileId[4];
extern	MEMORYSTATUS		mst;
extern	DWORD				dwCheckCrc32;
extern	DWORD				dwPassCrc32;
extern	LPBYTE				lpInBuffer;
extern	LPBYTE				lpOutBuffer;
extern	HICON				hIcon2;
extern	LPBYTE				lpCodeTable;
extern	LPBYTE				lpPStack;
extern	CODE_STATS			CodeStats;
extern	int					iMaxUnpack;
extern	DWORD				dwCodeTableSize;
extern	DWORD				dwPStackSize;
extern	LARGE_INTEGER		liHalfPercent;
extern	LARGE_INTEGER		liHalfPercentDup;
extern	SHFILEINFO			shfi1;
extern	BOOL				bWeHaveLzw;
extern	HFONT				hDlgFont;

// Variables used by the test procedure.
//......................................
DWORD				dwHdrPassCrc32;
TCHAR				szPackedHdrResults[] = "%u of %u Packed File Headers passed their integrity tests.";
TCHAR				szPackedFileResults[] = "%u of %u Packed Files passed their integrity tests.";

// Test a packed file for integrity.
//..................................
VOID TestAPackedFile()
{
	OPENFILENAME		ofn;
	ULARGE_INTEGER		uli;
	LARGE_INTEGER		liStats;
	LPBYTE				lpTestExt;
	DWORD				dwOldHelpTopic;
	DWORD				dwFilesTested;
	DWORD				dwHeadersTested;
	DWORD				dwBytesRead;
	DWORD				dwBytesToRead;
	BOOL				bResult;
	LONG				lResult;
	TCHAR				szOutBuffer[132];
	TCHAR				szPackedFileName[MAX_PATH];

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_TEST);

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	if (BPC())
	{
		goto TestEnd;
	}
	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szFileName;
	ofn.nMaxFile = sizeof(szFileName);
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Packed Files [.pkd]\0*.pkd\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select a Packed File to Test");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | OFN_HIDEREADONLY);
	ofn.lpstrDefExt = NULL;
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	while(TRUE)
	{
		ZeroMemory(&szFileName,sizeof(szFileName));

		// Select the file to unpack.
		//...........................
		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto TestEnd;
		}
		SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,TRUE);

		// Make sure the file is a valid packed file.
		//...........................................
		lpFileName = PathFindFileName((LPCTSTR)&szFileName);
		lpFileExtension = PathFindExtension((LPCTSTR)&szFileName);

		hInputFile = IsValidPackedFile((LPBYTE)&szFileName,TRUE);

		if (hInputFile)
		{
			break;
		}
	}
	EmptyTheMessageQue();

	// Setup the step increment for the progress bar.
	// Always equals one for this case.
	//...............................................
	iStepIncrement = 1;

	iNumberOfFiles = pfidhdr.iFilesInVault;

	// Determine the size of the file so we can determine how much
	// a half percent is.
	//............................................................
	uli.QuadPart = GetMyFileSize((LPTSTR)&szFileName,hInputFile);
	if (uli.QuadPart == -1)
	{
		goto TestEnd;
	}
	if (uli.QuadPart < 40000)
	{
			__asm
			{
				xor		edx,edx
				mov		eax,uli.LowPart
				mov		ecx,200
				div		ecx
				cmp		eax,edx
				jae		L1
				inc		eax
			L1:	mov		liHalfPercent.HighPart,0
				mov		liHalfPercent.LowPart,eax
			}
	}
	else
	{
		liHalfPercent.QuadPart = (uli.QuadPart / 200);
		if (liHalfPercent.QuadPart == 0)
		{
			liHalfPercent.QuadPart = 1;
		}
	}
	liHalfPercentDup.QuadPart = liHalfPercent.QuadPart;

	// Build a crc32 table, allocate memory, and initialize a few
	// variables.
	//...........................................................
	bResult = Crc32Table(BUILD_TABLE);
	if (!bResult)
	{
		goto TestEnd;
	}
	lpInBuffer = AllocateMemory(BUFFER_SIZE_IN);
	lpOutBuffer = AllocateMemory(BUFFER_SIZE_OUT);
	if (!lpInBuffer || !lpOutBuffer)
	{
		goto TestEnd;
	}
	dwPassCrc32 = 0;
	dwHdrPassCrc32 = 0;
	dwFilesTested = 0;
	dwHeadersTested = 0;

	// Setup the modeless dialog box for unpacking our files.
	//.......................................................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("TESTPACKEDFILE"),hMainWindow,
								  (DLGPROC)TestPackedFileProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto TestEnd;
	}
	// Process and test the packed files.
	//...................................
	while(iNumberOfFiles > 0)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto TestEnd;
		}
		// Read in a header entry.
		//........................
		ZeroMemory(&szPackedFileName,MAX_PATH);
		bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,&pfhdr,
						     sizeof(PACKED_FILE_HEADER),&dwBytesRead,NULL);
		// If we did not read in the required number of bytes.
		//....................................................
		if (dwBytesRead != sizeof(PACKED_FILE_HEADER))
		{
			SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
			ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
			goto TestEnd;
		}
		if (!bResult)
		{
			goto TestEnd;
		}
		// Check the header crc32 value.
		//..............................
		bResult = CheckHeaderCrc();
		if (!bResult)
		{
			goto TestEnd;
		}
		dwHdrPassCrc32++;
		dwHeadersTested++;

		// Read in the file name which follows the header.
		//................................................
		bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,&szPackedFileName,
							  pfhdr.wLengthOfFileName,&dwBytesRead,NULL);

		// If we did not read in the required number of bytes.
		//....................................................
		if (dwBytesRead != pfhdr.wLengthOfFileName)
		{
			SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
			ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
			goto TestEnd;
		}
		if (!bResult)
		{
			goto TestEnd;
		}
		lpTestExt = PathFindExtension((LPCTSTR)&szPackedFileName);

		// Setup the name and icon of the file being tested.
		// First delete any icon already being used.
		//..................................................
		if (hIcon2)
		{
			DestroyIcon(hIcon2);
		}
		hIcon2 = 0;
		SetDlgItemTextFmt(hDialogModeLess,IDC_FILE2,(LPCTSTR)&szPackedFileName);
		hIcon2 = FindMyIcon((LPBYTE)&szPackedFileName,lpTestExt);

		// If we did not find one, use the default.
		//.........................................
		if (!hIcon2)
		{
			hIcon2 = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
		}
		if (hIcon2)
		{
			SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON2),STM_SETICON,(WPARAM)hIcon2,0);
		}

		EmptyTheMessageQue();

		// Check to see if the file is just stored or compressed.
		//.......................................................
		if (pfhdr.LargestBitCode == 0)
		{
			dwCheckCrc32 = -1;
			uli.QuadPart = pfhdr.uliCompressedFileSize.QuadPart;
			liStats.QuadPart = 0;
			
			while(uli.QuadPart > 0)
			{
				if (uli.QuadPart > BUFFER_SIZE_IN)
				{
					dwBytesToRead = BUFFER_SIZE_IN;
					uli.QuadPart -= BUFFER_SIZE_IN;
				}
				else
				{
					dwBytesToRead = uli.LowPart;
					uli.QuadPart = 0;
				}
				bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,
									 lpInBuffer,dwBytesToRead,&dwBytesRead,NULL);

				// If we did not read in the required number of bytes.
				//....................................................
				if (dwBytesRead != dwBytesToRead)
				{
					SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
					ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
					goto TestEnd;
				}
				if (!bResult)
				{
					goto TestEnd;
				}
				// Calculate the crc32 check value.
				//.................................
				__asm
				{
					mov		edi,lpInBuffer
					mov		ecx,dwBytesRead
				L2:	mov		al,byte ptr [edi]
					xor		al,byte ptr dwCheckCrc32
					shr		dwCheckCrc32,8
					movzx	esi,al
					mov		ebx,lpCrc32Table
					mov		edx,dword ptr [ebx][esi*4]
					xor		dwCheckCrc32,edx
					inc		edi
					dec		ecx
					jnz		L2
				}
				// Update the status bar to reflect this file.
				//............................................
				liStats.QuadPart += dwBytesRead;
				while(liStats.QuadPart >= liHalfPercentDup.QuadPart)
				{
					SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
					liStats.QuadPart -= liHalfPercentDup.QuadPart;
				}
			}
		}
		else
		{
			// Check to see if we can test this file.
			//.......................................
			if (bWeHaveLzw)
			{
				SetMaxCodeSizeOnStartUp();
				if (pfhdr.LargestBitCode > iMaxUnpack)
				{
					SetLastError(IDS_NOTENOUGHMEMORYTOTEST);
					lResult = ErrorProcedure((LPTSTR)&szPackedFileName,
											  IDS_ALLOCATEMEMORY,MB_OKCANCEL);
					if (lResult == IDCANCEL)
					{
						goto TestEnd;
					}
					// We have to get past the compressed data to
					// the next file header.
					//...........................................
					uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,
												     pfhdr.uliCompressedFileSize.QuadPart,
												     FILE_CURRENT);
					if (uli.QuadPart == -1)
					{
						goto TestEnd;
					}
					iNumberOfFiles--;
					continue;
				}
				// Allocate the extended memory as required for each
				// file as it is to be tested.
				//..................................................
				SetLzwParameters((LPCODE_STATS)&CodeStats,pfhdr.LargestBitCode);
				lpCodeTable = AllocateMemory(dwCodeTableSize);
				lpPStack = AllocateMemory(dwPStackSize);
				if (!lpCodeTable || !lpPStack)
				{
					goto TestEnd;
				}
				// Decompress the file. The handle for the output file
				// must be 0 so nothing is written to disk.
				//....................................................
				bResult = DecompressTheFile((LPBYTE)&szFileName,hInputFile,NULL,0);
				if (!bResult)
				{
					goto TestEnd;
				}
				// We are done with this file. Deallocate the memory
				// for the code and pseudo stack.
				//..................................................
				bResult = DeallocateMemory(lpCodeTable);
				if (!bResult)
				{
					goto TestEnd;
				}
				lpCodeTable = 0;
				bResult = DeallocateMemory(lpPStack);
				if (!bResult)
				{
					goto TestEnd;
				}
				lpPStack = 0;
			}
			else
			{
				// We have a zip file to text.
				//............................
				bResult = UnzipMyFile((LPBYTE)&szFileName,hInputFile,NULL,0);
				if (!bResult)
				{
					goto TestEnd;
				}
			}
		}
		// Check the crc32 check value and close out the file after
		// adding the times and attributes.
		//.........................................................
		if (bWeHaveLzw)
		{
			dwCheckCrc32 ^= -1;
		}
		if (dwCheckCrc32 != pfhdr.dwFileCrc32)
		{
			SetLastError(IDS_TESTINTEGRITYFAILED);
			ErrorProcedure((LPTSTR)&szPackedFileName,IDS_READ,MB_OK);
		}
		else
		{
			dwPassCrc32++;
		}
		dwFilesTested++;
		
		// Print running stats.
		//.....................
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szPackedHdrResults,
						dwHdrPassCrc32,dwHeadersTested);
		SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szPackedFileResults,
					    dwPassCrc32,dwFilesTested);
		SetDlgItemText(hDialogModeLess,IDC_STATEMENT2,(LPCTSTR)&szOutBuffer);

		iNumberOfFiles--;
	}
	// Print final stats.
	//...................
	StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szPackedHdrResults,
					dwHdrPassCrc32,dwHeadersTested);
	SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);
	StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szPackedFileResults,
					dwPassCrc32,dwFilesTested);
	SetDlgItemText(hDialogModeLess,IDC_STATEMENT2,(LPCTSTR)&szOutBuffer);

	// Set the position of the progress bar to 100% if we did not quit
	// or exit with an error
	//................................................................
	if (!bCancelOperation)
	{
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,(WPARAM)200,0);
	}
	// Make sure bCancelOperation is set to FALSE.
	//............................................
	bCancelOperation = FALSE;

	// Change the cancel button to ok.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	FlashMyIcon(TRUE);

	// Wait until we close the dialog box to exit.
	//............................................
	while(TRUE)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			break;
		}
	}

	TestEnd:

	FlashMyIcon(FALSE);

	Crc32Table(DELETE_TABLE);

	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	if (hIcon2)
	{
		DestroyIcon(hIcon2);
		hIcon2 = 0;
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (lpInBuffer)
	{
		ZeroMemory(lpInBuffer,BUFFER_SIZE_IN);
		DeallocateMemory(lpInBuffer);
		lpInBuffer = 0;
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,BUFFER_SIZE_OUT);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	if (lpCodeTable)
	{
		DeallocateMemory(lpCodeTable);
		lpCodeTable = 0;
	}
	if (lpPStack)
	{
		DeallocateMemory(lpPStack);
		lpPStack = 0;
	}
	if (hInputFile)
	{
		CloseMyHandle((LPTSTR)&szFileName,hInputFile);
		hInputFile = 0;
	}
	ChangeHelpTopic(dwOldHelpTopic);
	bCancelOperation = FALSE;
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for testing a packed file.
//..............................................
LRESULT CALLBACK TestPackedFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			TCHAR			szOutBuffer[64];

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			SetBoldFont(hDlg,IDC_STATEMENT1,IDC_STATEMENT2);

			// Setup the range and step increment for the progress bar.
			//.........................................................
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,(LPARAM)200);
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			// Set the number of files to test.
			//.................................
			StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),TEXT("%d"),
							pfidhdr.iFilesInVault);
			SetDlgItemText(hDlg,IDC_NUMBERLEFT,(LPCTSTR)&szOutBuffer);

			// Setup the name of the file to test.
			//....................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileName));

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}
